//
//  ViewController.swift
//  DragToDelete
//
//  Created by 9Brainz on 16/10/18.
//  Copyright © 2018 9Brainz. All rights reserved.
//

import UIKit

class ViewController: UIViewController,UIGestureRecognizerDelegate
{

    @IBOutlet weak var imgDelete: UIImageView!
    @IBOutlet weak var imgFile: UIImageView!
    @IBOutlet var objPan: UIPanGestureRecognizer!
    
    var arrAddView = Array<Any>()
    let screenHeight: CGFloat = UIScreen.main.bounds.size.height
    let screeWidth: CGFloat = UIScreen.main.bounds.size.width
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        objPan.delegate = self
        imgDelete.isHidden = true
        arrAddView.append(imgFile)
    }

    @IBAction func btnResetTap(_ sender: Any)
    {
        imgDelete.isHidden = true
        
        let imageName = "file"
        let image = UIImage(named: imageName)
        let imageView = UIImageView(image: image!)
        imageView.frame = CGRect(x: 16, y: 20, width: 80, height: 80)
        arrAddView.append(imageView)
        view.addSubview(imageView)
       
        let panGesture = UIPanGestureRecognizer(target: self, action: #selector(self.handlePan(recognizer:)))
        imageView.isUserInteractionEnabled = true
        imageView.addGestureRecognizer(panGesture)
    }
   
    @IBAction func handlePan(recognizer: UIPanGestureRecognizer)
    {
        let translation = recognizer.translation(in: self.view)
        
        if recognizer.state == UIGestureRecognizerState.began
        {
            imgDelete.isHidden = false
        }
        if recognizer.state == UIGestureRecognizerState.ended
        {
            imgDelete.isHidden = true
        }
        
        if let view = recognizer.view
        {
            view.center = CGPoint(x:view.center.x + translation.x,y:view.center.y + translation.y)
            print("XPosition : \(view.center.x)")
            print("YPosition : \(view.center.y)")
            
            if ((view.center.y <= (screenHeight - 60)) && (view.center.y >= (screenHeight - 140)) && (view.center.x >= (screeWidth/2 - 50)) && (view.center.x <= (screeWidth/2 + 50)))
            {
                imgDelete.pulsate()
                var i = 0
                while i < self.arrAddView.count
                {
                    (self.arrAddView[i] as AnyObject).removeFromSuperview()
                    i += 1
                }
                DispatchQueue.main.asyncAfter(deadline: .now() + 0.3)
                {
                    self.imgDelete.isHidden = true
                }
            }
        }
        
        recognizer.setTranslation(CGPoint.zero, in: self.view)
        
        
    }
}

extension UIView
{
    // pulsate() use for uiimage view animation
    func pulsate() {
        let pulse = CASpringAnimation(keyPath: "transform.scale")
        pulse.duration = 0.3
        pulse.fromValue = 0.95
        pulse.toValue = 1
        pulse.autoreverses = true
        pulse.repeatCount = 1
        pulse.initialVelocity = 0.5
        pulse.damping = 1.0
        layer.add(pulse, forKey: nil)
    }
}
